XenoRewardMultiplier = 1.5
Include([[Data/levels/include/xeno_template.lua]])

function Level.MapGenScript()

    MapGeometry:Randomize(60000)
		
	LevelUtils.MapGenDefaults.CapPtDangerRadius = 31.0
    MapEntities:SetParameters(LevelUtils.MapGenDefaults)
    MapEntities:GenerateLocations()

	--Capture point placement
	for i=1, 4 do
		MapEntities:PlaceCapPoint(false, -1, 1, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
	end

	for i=1, 3 do
		MapEntities:PlaceCapPoint(false, -1, 2, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
	end
	
	MapEntities:PlaceCapPoint(false, -1, 3, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
	MapEntities:PlaceCapPoint(false, -1, 0, false, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
    --local homeBase = MapEntities:PlaceCapPoint(true, -1, 0, false, 90.0, "");
    local homePos = vect2f()
    local homePlaced = MapEntities:GetStartingPlace(homePos, 90.0)
    
    if homePlaced then
        GameWorld:AddMarines(homePos, GameWorld:GetStartingTeamSize())
        GameWorld:ResetCamera(homePos)
        --GameWorld:FocusCameraOn(homeBase)
        
        local bunker = GameWorld:CreateEntity("PropBuilding", "xenoBunker", homePos)
        
        GameWorld:RegisterRaidTarget(bunker)
        GameWorld:RegisterRespawnSource(bunker)
        
        local building = bunker:ToCHumanBuilding()
        building:CompleteBuilding()
        
        BunkerLostScript:OnBunkerCreated()
    end
    
	--Alien support structs
	MapEntities:PlaceEnemyStuctures(5.0, 4.0);
	
	--Place crates
	for i=1, 4 do
		MapEntities:PlaceBPCrate(20.0, 60.0, 15.0);
	end
	
	for i=1, 3 do
		MapEntities:PlaceAPCrate(14.0, 20.0, 6.0);
	end	
end

Level.Parameters =
{
	MarineCount 		= 5,
	MaxHiveLevel 		= 4,
	MaxSpawnRate 		= 24.0,
	StartBPMultiplier 	= 1.0,
	BPGainMultiplier    = 1.0,
	
	DefaultHiveTowerCount = 10,
}
		
Level.Mutations =
{
	CapturesPerMutation = 1,
	MaxMutations = 8,
	Default = [[disabled]],
	Active =
	{
	},
	Inactive =
	{
		[[ZU_SLOWING_POISON]],
		[[ZU_REGENERATION]],		
		[[ZU_ZOMBIE_MINES]],	
		[[ZU_RUST]],

		[[ZU_BOMBARDMENT]],
		[[ZU_HIVE_SPIKES]],		
		[[ZU_WALK_SPEED]],	
		[[ZU_REVIVAL]],
		[[ZU_SPIKE_POWER]],
		[[ZU_MARTYRDOM]],	

		[[ZU_BONE_SHIELD]],
		[[ZU_TOWER_CARAPACE]],
		[[ZU_TOWER_CONSUMPTION]],		
		[[ZU_IMMUNITY]],	
		[[ZU_SPAWNER_SPECIAL]],
		[[ZU_SPAWN_BRUTES]],	
		[[ZU_DEF_BRUTES]],
		[[ZU_MIMICRY]],

		[[ZU_SANDKING_GUARDIANS]],
		[[ZU_SHARPNESS]],
		[[ZU_SPAWN_SPITTERS]],		
		[[ZU_DEF_SPITTERS]],	
		[[ZU_CLONES]],
		[[ZU_DEATH_BONES]],
		[[ZU_DEF_ENRAGED]],
		[[ZU_SPAWN_ENRAGED]],		
	},		
	Queue =
	{
		[[ZU_NONE]],
	},
	Disabled =
	{
	},
	Randomize = true
}
